(* Translate a simple imperative program into OCaml code by 
   representing the OCaml program as a string.

   Motivates some of the challenges of building a compiler:
     - why string are a bad choice for representing programs


 *)

;; open Simple

module OrderedVars = struct
  type t = var
  let compare = String.compare
end

module VSet = Set.Make(OrderedVars)
let (++) = VSet.union

(* 
  Calculate the set of variables mentioned in either an expression or a command. 
*)

let rec vars_of_exp (e:exp) : VSet.t =
  failwith "todo"
 
let rec vars_of_cmd (c:cmd) :VSet.t =
  failwith "todo"

(* 
  The translation invariants are guided by the _types_ of the operations:

  - variables are global state, so they become mutable references
  - expressions denote integers
  - commands denote imperative actions of type unit

  [[ state : Var => Int ]]
  [[ Var ]] = int ref 

  [[ X ]] : int ref

  [[ exp ]] : int

  [[ cmd ]] : unit
*)

let trans_var (x:var) : string =

  
let rec trans_exp (e:exp) : string =


let rec trans_cmd (c:cmd) : string =


let trans_prog (c:cmd) : string =
