open Big_int

type t = { value : int64; overflow : bool }

let ok i = { value = i; overflow = false }

exception Overflow

let with_overflow1 g f i =
  let res = f i in 
  { value = res
  ; overflow = eq_big_int (big_int_of_int64 res) (g @@ big_int_of_int64 i)
  } 
  
let with_overflow2 g f i j =
  let res = f i j in
  { value = res
  ; overflow = eq_big_int (big_int_of_int64 res) 
			  (g (big_int_of_int64 i) (big_int_of_int64 j))
  } 

let neg = with_overflow1 minus_big_int Int64.neg
let succ = with_overflow1 succ_big_int Int64.succ
let pred = with_overflow1 pred_big_int Int64.pred

let add = with_overflow2 add_big_int Int64.add
let sub = with_overflow2 sub_big_int Int64.sub
let mul = with_overflow2 mult_big_int Int64.mul
let div = with_overflow2 div_big_int Int64.div
let rem = with_overflow2 mod_big_int Int64.rem

let logand = with_overflow2 and_big_int Int64.logand
let logor  = with_overflow2 or_big_int Int64.logor
let logxor = with_overflow2 xor_big_int Int64.logxor
let lognot i = { value = Int64.lognot i; overflow = false }

let shift_left i j = with_overflow1 (fun x -> shift_left_big_int x j) 
				    (fun x -> Int64.shift_left x j) i
let shift_right i j = with_overflow1 (fun x -> shift_right_towards_zero_big_int x j)
				     (fun x -> Int64.shift_right x j) i
let shift_right_logical i j = with_overflow1 (fun x -> shift_right_big_int x j)
					     (fun x -> Int64.shift_right_logical x j) i


